<?php
/* --------------------------------------------------------------
  GmConfigurationService.php 2019-08-14
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

/**
 * Class GmConfigurationService
 */
class GmConfigurationService implements GmConfigurationServiceInterface
{
    /**
     * @var GmConfigurationRepositoryInterface
     */
    protected $repository;
    
    
    /**
     * GmConfigurationService constructor.
     *
     * @param GmConfigurationRepositoryInterface $repository
     */
    public function __construct(GmConfigurationRepositoryInterface $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @param string $key
     *
     * @return GmConfigurationInterface
     */
    public function getConfigurationByKey(string $key): GmConfigurationInterface
    {
        return $this->repository->getConfigurationByKey($key);
    }
    
    
    /**
     * @param GmConfigurationInterface $configuration
     */
    public function updateGmConfiguration(GmConfigurationInterface $configuration): void
    {
        $this->repository->updateGmConfiguration($configuration);
    }
}